# ================================================================
# Mejselfix Baseline Check v1.1
# Forensisk grundskanning för Windows-system
# Loggar processer, autostarts, drivrutiner, tjänster, nätverk,
# schemalagda uppgifter samt nyligen ändrade EXE/DLL.
# ================================================================

# --- Loggfil ---
$Report = "$env:USERPROFILE\Desktop\CF53_Forensic_Report.txt"
"=== MEJSELFIX BASELINE CHECK ($(Get-Date)) ===`n" | Out-File $Report -Encoding UTF8

# ================================================================
# PROCESSER + SIGNATURER
# ================================================================
"== Aktiva processer ==" | Out-File $Report -Append -Encoding UTF8
Get-Process | ForEach-Object {
    $p = $_
    $path = $null
    $signer = "Ej signerad"

    try { $path = $p.Path } catch {}
    if ($path) {
        try {
            $sig = Get-AuthenticodeSignature $path
            if ($sig.SignerCertificate) { $signer = $sig.SignerCertificate.Subject }
        } catch {}
    }

    "$($p.Name) | PID: $($p.Id) | Signerare: $signer | Path: $path" |
    Out-File $Report -Append -Encoding UTF8
}

# ================================================================
# AUTOSTARTS (Run, RunOnce)
# ================================================================
"== Autostarts (Run, RunOnce) ==" | Out-File $Report -Append -Encoding UTF8

Get-ItemProperty -Path "HKLM:\Software\Microsoft\Windows\CurrentVersion\Run*" -ErrorAction SilentlyContinue |
Select-Object * -ExcludeProperty PSPath,PSParentPath,PSChildName,PSDrive,PSProvider |
Out-File $Report -Append -Encoding UTF8

Get-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\Run*" -ErrorAction SilentlyContinue |
Select-Object * -ExcludeProperty PSPath,PSParentPath,PSChildName,PSDrive,PSProvider |
Out-File $Report -Append -Encoding UTF8

# ================================================================
# SCHEMALAGDA UPPGIFTER
# ================================================================
"== Schemalagda uppgifter ==" | Out-File $Report -Append -Encoding UTF8
Get-ScheduledTask | Select-Object TaskName, TaskPath, State |
Out-File $Report -Append -Encoding UTF8

# ================================================================
# NÄTVERKSANSLUTNINGAR
# ================================================================
"== Aktiva nätverksanslutningar ==" | Out-File $Report -Append -Encoding UTF8
Get-NetTCPConnection |
Select-Object LocalAddress,LocalPort,RemoteAddress,RemotePort,State,OwningProcess |
Out-File $Report -Append -Encoding UTF8

# ================================================================
# TJÄNSTER
# ================================================================
"== Tjänster ==" | Out-File $Report -Append -Encoding UTF8
Get-WmiObject Win32_Service | ForEach-Object {
    "$($_.Name) | Status: $($_.State) | Path: $($_.PathName)" |
    Out-File $Report -Append -Encoding UTF8
}

# ================================================================
# DRIVRUTINER
# ================================================================
"== Drivrutiner ==" | Out-File $Report -Append -Encoding UTF8
Get-WmiObject Win32_SystemDriver |
Select-Object Name, State, PathName, StartMode |
Out-File $Report -Append -Encoding UTF8

# ================================================================
# SENAST ÄNDRADE EXE/DLL (14 DAGAR)
# ================================================================
"== Nyligen ändrade körbara filer (EXE/DLL, senaste 14 dagar) ==" |
Out-File $Report -Append -Encoding UTF8

Get-ChildItem -Path C:\ -Recurse -Include *.exe,*.dll -ErrorAction SilentlyContinue |
Where-Object { $_.LastWriteTime -gt (Get-Date).AddDays(-14) } |
Select-Object FullName, LastWriteTime |
Out-File $Report -Append -Encoding UTF8

"`n=== GENOMKÖRT ===" | Out-File $Report -Append -Encoding UTF8
Write-Host "Skanning klar. Rapport skapad på skrivbordet: $Report"
